(function() {
    'use strict';

    /**
     * object used to hold key/value pairs
     *
     * @private
     * @type {object}
     */
    var obj;

    if (Map) {
        // Browser supports ES6 Maps.  Use native implementation instead.
        return;
    }

    obj = Object.create(null);

    /**
     * WARNING: NOT A FULL ES6 Map SHIM !!!!
     *
     * ES6 Maps cannot be properly shimed.
     * Instead, here we define a subset of the ES6 Map functionality.
     */
    function Map() { } // jshint ignore:line

    /**
     * Returns the number of key/value pairs in the Map object.
     */
    Map.prototype.size = 0;

    /**
     * Adds a new element with a specified key and value.
     *
     * WARNING: unlike ES6 Maps, keys are limited to specific types
     *
     * @param {string|number} key
     * @param {*} value
     */
    Map.prototype.set = function(key, value) {
        if (Object.prototype.hasOwnProperty.call(obj, key)) {
            // new key
            this.size++;
        }

        this.obj[key] = value;
    };

    /**
     * Returns the value associated to the key, or undefined if there is none.
     *
     * @param {string|number} key
     * @return {*} the value associated to the key, or undefined if there is none.
     */
    Map.prototype.get = function(key) {
        return (Object.prototype.hasOwnProperty.call(obj, key)) ? obj[key] : undefined;
    };

    /**
     * Executes a provided function once per each key/value pair in the Map object.
     *
     * @param {function} cb
     */
    Map.prototype.forEach = function(cb) {
        var keys = Object.keys(obj),
            i;

        for (i = 0; i < keys.length; i++) {
            /**
             * @callback cb
             * @param {*} value
             * @param {*} key
             * @param {Map} map being traversed
             */
            cb.call(this, obj[keys[i]], keys[i], this);
        }
    };

    window.Map = Map;
})();
